<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header p-3">
                    <h5 class="mb-2">Referral Program</h5>
                    <p class="mb-0">Track and find all the details about our referral program, your stats and revenues.
                    </p>
                </div>
                <div class="card-body p-3">
                    <div class="row">
                        <div class="col-3 text-center">
                            <div class="border-dashed border-1 border-secondary border-radius-md py-3">
                                <h6 class="text-primary text-gradient mb-0">Earnings</h6>
                                <h4 class="font-weight-bolder"><span class="small">$ </span><span id="state1"
                                        countTo="23980"></span></h4>
                            </div>
                        </div>
                        <div class="col-3 text-center">
                            <div class="border-dashed border-1 border-secondary border-radius-md py-3">
                                <h6 class="text-primary text-gradient mb-0">Customers</h6>
                                <h4 class="font-weight-bolder"><span class="small">$ </span><span id="state2"
                                        countTo="2400"></span></h4>
                            </div>
                        </div>
                        <div class="col-3 text-center">
                            <div class="border-dashed border-1 border-secondary border-radius-md py-3">
                                <h6 class="text-primary text-gradient mb-0">Avg. Value</h6>
                                <h4 class="font-weight-bolder"><span class="small">$ </span><span id="state3"
                                        countTo="48"></span></h4>
                            </div>
                        </div>
                        <div class="col-3 text-center">
                            <div class="border-dashed border-1 border-secondary border-radius-md py-3">
                                <h6 class="text-primary text-gradient mb-0">Refund Rate</h6>
                                <h4 class="font-weight-bolder"><span id="state4" countTo="4"></span><span class="small">
                                        %</span></h4>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-5">
                        <div class="col-5">
                            <h6 class="mb-0">Referral Code</h6>
                            <p class="text-sm">Copy the code bellow to your registered provider.</p>
                            <div class="border-dashed border-1 border-secondary border-radius-md p-3">
                                <p class="text-xs mb-2">Generated 23 days ago by <span
                                        class="font-weight-bolder">softuidash23</span></p>
                                <p class="text-xs mb-3"><span class="font-weight-bolder">(Used one time)</span></p>
                                <div class="d-flex align-items-center">
                                    <div class="form-group w-70">
                                        <div class="input-group bg-gray-200">
                                            <input class="form-control" value="soft-ui-dashboard-vmsk392" type="text"
                                                disabled>
                                            <span class="input-group-text bg-transparent" data-bs-toggle="tooltip"
                                                data-bs-placement="top" title="Referral code expires in 24 hours"><i
                                                    class="ni ni-key-25"></i></span>
                                        </div>
                                    </div>
                                    <a href="javascript:;" class="btn btn-sm btn-outline-secondary ms-2 px-3">Copy</a>
                                </div>
                                <p class="text-xs mb-1">You cannot generate codes.</p>
                                <p class="text-xs mb-0"><a href="javascript:;">Contact us</a> to generate more referrals
                                    link.</p>
                            </div>
                        </div>
                        <div class="col-7">
                            <h6 class="mb-0">How to use</h6>
                            <p class="text-sm">Integrate your referral code in 3 easy steps.</p>
                            <div class="row">
                                <div class="col-4">
                                    <div class="card card-plain text-center">
                                        <div class="card-body">
                                            <div
                                                class="icon icon-shape bg-gradient-dark shadow text-center border-radius-md mb-2">
                                                <i class="ni ni-money-coins text-lg opacity-10" aria-hidden="true"></i>
                                            </div>
                                            <p class="text-sm font-weight-bold mb-2">1. Create & validate your referral
                                                link and get </p>
                                            <h5 class="font-weight-bolder"><span class="small">$</span>100</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="card card-plain text-center">
                                        <div class="card-body">
                                            <div
                                                class="icon icon-shape bg-gradient-dark shadow text-center border-radius-md mb-2">
                                                <i class="ni ni-send text-lg opacity-10" aria-hidden="true"></i>
                                            </div>
                                            <p class="text-sm font-weight-bold mb-2">2. For every order you make you get
                                            </p>
                                            <h5 class="font-weight-bolder">10<span class="small">%</span></h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="card card-plain text-center">
                                        <div class="card-body">
                                            <div
                                                class="icon icon-shape bg-gradient-dark shadow text-center border-radius-md mb-2">
                                                <i class="ni ni-spaceship text-lg opacity-10" aria-hidden="true"></i>
                                            </div>
                                            <p class="text-sm font-weight-bold mb-2">3. Get other friends to generate
                                                link and get </p>
                                            <h5 class="font-weight-bolder"><span class="small">$</span>500</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr class="horizontal dark">
                    <div class="row mt-4">
                        <h6 class="mb-2">Other programs</h6>
                        <div class="col-4">
                            <div class="card text-center">
                                <div class="overflow-hidden position-relative border-radius-lg bg-cover p-3"
                                    style="background-image: url('https://raw.githubusercontent.com/creativetimofficial/public-assets/master/soft-ui-design-system/assets/img/window-desk.jpg')">
                                    <span class="mask bg-gradient-dark opacity-6"></span>
                                    <div class="card-body position-relative z-index-1 d-flex flex-column mt-5">
                                        <p class="text-white font-weight-bolder">User #hashtag in a photo on social
                                            media and <span class="text-primary text-gradient">get $10 for each purchase
                                                you make.</span> </p>
                                        <a class="text-white text-sm font-weight-bold mb-0 icon-move-right mt-4"
                                            href="javascript:;">
                                            Read More
                                            <i class="fas fa-arrow-right text-sm ms-1" aria-hidden="true"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="card text-center">
                                <div class="overflow-hidden position-relative border-radius-lg bg-cover p-3"
                                    style="background-image: url('../../assets/img/office-dark.jpg')">
                                    <span class="mask bg-gradient-dark opacity-6"></span>
                                    <div class="card-body position-relative z-index-1 d-flex flex-column mt-5">
                                        <p class="text-white font-weight-bolder">Send the invitation link to 10 friends
                                            and <span class="text-primary text-gradient">get a 50% coupon to use on any
                                                purchase.</span> </p>
                                        <a class="text-white text-sm font-weight-bold mb-0 icon-move-right mt-4"
                                            href="javascript:;">
                                            Read More
                                            <i class="fas fa-arrow-right text-sm ms-1" aria-hidden="true"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="card border-dashed border-1 text-center h-100">
                                <div class="card-body position-relative z-index-1 d-flex flex-column">
                                    <div
                                        class="position-relative d-flex align-items-center justify-content-center h-100">
                                        <img class="w-50 position-relative z-index-2"
                                            src="../../assets/img/illustrations/rocket-white.png">
                                    </div>
                                    <a class="text-sm text-secondary font-weight-bold mb-0 icon-move-right mt-2"
                                        href="javascript:;">
                                        Join rocketship program
                                        <i class="fas fa-arrow-right text-sm ms-1" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 mt-4">
            <div class="card mb-4">
                <div class="card-header pb-0 p-3">
                    <h6>Top Referred Users</h6>
                </div>
                <div class="card-body px-0 pt-0 pb-2">
                    <div class="table-responsive p-0">
                        <table class="table align-items-center mb-0">
                            <thead>
                                <tr>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">User
                                    </th>
                                    <th
                                        class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                        Value</th>
                                    <th
                                        class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Profit</th>
                                    <th
                                        class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Refunds</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="d-flex px-3 py-1">
                                            <div>
                                                <img src="../../assets/img/team-1.jpg" class="avatar me-3">
                                            </div>
                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm">Alice Vinget</h6>
                                                <p class="text-sm font-weight-bold text-secondary mb-0"><span
                                                        class="text-success">8.232</span> orders</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <p class="text-sm font-weight-bold mb-0">$130.992</p>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <p class="text-sm font-weight-bold mb-0">$9.500</p>
                                    </td>
                                    <td class="align-middle text-end">
                                        <div class="d-flex px-3 py-1 justify-content-center align-items-center">
                                            <p class="text-sm font-weight-bold mb-0">13</p>
                                            <i class="ni ni-bold-down text-sm ms-1 mt-1 text-success"></i>
                                            <button type="button"
                                                class="btn btn-sm btn-icon-only btn-rounded btn-outline-secondary mb-0 ms-2 btn-sm d-flex align-items-center justify-content-center ms-3"
                                                data-bs-toggle="tooltip" data-bs-placement="bottom" title=""
                                                data-bs-original-title="Refund rate is lower with 97% than other users">
                                                <i class="fas fa-info" aria-hidden="true"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="d-flex px-3 py-1">
                                            <div>
                                                <img src="../../assets/img/team-2.jpg" class="avatar me-3">
                                            </div>
                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm">John Alura</h6>
                                                <p class="text-sm font-weight-bold text-secondary mb-0"><span
                                                        class="text-success">12.821</span> orders</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <p class="text-sm font-weight-bold mb-0">$80.250</p>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <p class="text-sm font-weight-bold mb-0">$4.200</p>
                                    </td>
                                    <td class="align-middle text-end">
                                        <div class="d-flex px-3 py-1 justify-content-center align-items-center">
                                            <p class="text-sm font-weight-bold mb-0">40</p>
                                            <i class="ni ni-bold-down text-sm ms-1 mt-1 text-success"></i>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="d-flex px-3 py-1">
                                            <div>
                                                <img src="../../assets/img/team-3.jpg" class="avatar me-3">
                                            </div>
                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm">Andrew Sian</h6>
                                                <p class="text-sm font-weight-bold text-secondary mb-0"><span
                                                        class="text-success">2.421</span> orders</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <p class="text-sm font-weight-bold mb-0">$40.600</p>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <p class="text-sm font-weight-bold mb-0">$9.430</p>
                                    </td>
                                    <td class="align-middle text-end">
                                        <div class="d-flex px-3 py-1 justify-content-center align-items-center">
                                            <p class="text-sm font-weight-bold mb-0">54</p>
                                            <i class="ni ni-bold-up text-sm ms-1 mt-1 text-danger"></i>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="d-flex px-3 py-1">
                                            <div>
                                                <img src="../../assets/img/team-4.jpg" class="avatar me-3">
                                            </div>
                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm">Luca Willaim</h6>
                                                <p class="text-sm font-weight-bold text-secondary mb-0"><span
                                                        class="text-success">5.921</span> orders</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <p class="text-sm font-weight-bold mb-0">$91.300</p>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <p class="text-sm font-weight-bold mb-0">$7.364</p>
                                    </td>
                                    <td class="align-middle text-end">
                                        <div class="d-flex px-3 py-1 justify-content-center align-items-center">
                                            <p class="text-sm font-weight-bold mb-0">5</p>
                                            <i class="ni ni-bold-down text-sm ms-1 mt-1 text-success"></i>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="d-flex px-3 py-1">
                                            <div>
                                                <img src="../../assets/img/team-5.jpg" class="avatar me-3">
                                            </div>
                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm">Richel Manuel</h6>
                                                <p class="text-sm font-weight-bold text-secondary mb-0"><span
                                                        class="text-success">921</span> orders</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <p class="text-sm font-weight-bold mb-0">$140.925</p>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <p class="text-sm font-weight-bold mb-0">$20.531</p>
                                    </td>
                                    <td class="align-middle text-end">
                                        <div class="d-flex px-3 py-1 justify-content-center align-items-center">
                                            <p class="text-sm font-weight-bold mb-0">121</p>
                                            <i class="ni ni-bold-up text-sm ms-1 mt-1 text-danger"></i>
                                            <button type="button"
                                                class="btn btn-sm btn-icon-only btn-rounded btn-outline-secondary mb-0 ms-2 btn-sm d-flex align-items-center justify-content-center ms-3"
                                                data-bs-toggle="tooltip" data-bs-placement="bottom" title=""
                                                data-bs-original-title="Refund rate is higher with 70% than other users">
                                                <i class="fas fa-info" aria-hidden="true"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--  Plugin for TypedJS, full documentation here: https://github.com/inorganik/CountUp.js -->
<script src="../../assets/js/plugins/countup.min.js"></script>
<script type="text/javascript">
    if (document.getElementById('state1')) {
        const countUp = new CountUp('state1', document.getElementById("state1").getAttribute("countTo"));
        if (!countUp.error) {
            countUp.start();
        } else {
            console.error(countUp.error);
        }
    }
    if (document.getElementById('state2')) {
        const countUp = new CountUp('state2', document.getElementById("state2").getAttribute("countTo"));
        if (!countUp.error) {
            countUp.start();
        } else {
            console.error(countUp.error);
        }
    }
    if (document.getElementById('state3')) {
        const countUp = new CountUp('state3', document.getElementById("state3").getAttribute("countTo"));
        if (!countUp.error) {
            countUp.start();
        } else {
            console.error(countUp.error);
        }
    }
    if (document.getElementById('state4')) {
        const countUp = new CountUp('state4', document.getElementById("state4").getAttribute("countTo"));
        if (!countUp.error) {
            countUp.start();
        } else {
            console.error(countUp.error);
        }
    }

</script>

